/*
*****************************************************************************
[Description]
	PCI-Express Test Solution (PETS) Base Class
	Original Code by Vincent Yang, Aug/28/2005
	Porting to DOS,Linux by Kikimum

**********************************************************************************
*/							 	
#ifndef __SOLITON_PETs_H__
#define __SOLITON_PETs_H__

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
//#include <curses.h>
#include <fcntl.h>
#include <linux/i2c.h>
#include <i2c-dev.hh>

#define PEMCTRL_SUCCESS				0
#define PEMCTRL_ERROR				1
#define PEMCTRL_ERROR_PEMNOTEXIST	2
#define PEMCTRL_ERROR_ADCNOTEXIST	3
#define PEMCTRL_ERROR_POWERFAIL		4
#define PEMCTRL_ERROR_DEVNOTEXIST	5
#define PEMCTRL_ERROR_DEVNOTMATCH	6
#define PEMCTRL_ERROR_DEVNEEDCFG	7

#define CPEMDLL_SUCCESS				0
#define CPEMDLL_FAIL				1
#define CPEMDLL_ERROR_PEMNOTEXIST	2
#define CPEMDLL_ERROR_ADCNOTEXIST	3
#define CPEMDLL_ERROR_POWERFAIL		4
#define CPEMDLL_ERROR_DEVNOTEXIST	5
#define CPEMDLL_ERROR_DEVNOTMATCH	6
#define CPEMDLL_ERROR_DEVNEEDCFG	7
#define CPEMDLL_ERROR_3V3AUXSHORT	0x01
#define CPEMDLL_ERROR_3V3SHORT		0x02
#define CPEMDLL_ERROR_1V5SHORT		0x04
#define PEMCTRL_ERROR_3V3AUXSHORT	0x01
#define PEMCTRL_ERROR_3V3SHORT		0x02
#define PEMCTRL_ERROR_1V5SHORT		0x04
#define CPEMDLL_MAJOR_VERSION	1
#define CPEMDLL_MINOR_VERSION	1	

int INIT();
int EXIT();
int SELPEM(unsigned long modaddr);
int VALIDPEM(unsigned long modaddr);
int VALIDDEV();
int PON();
int POFF();
int GETPWRSTS();
int GET3V3V(double* volt);
int GET3V3I(double* amp);
int PWRCTL_AUTO();
int PWRCTL_MANUAL();
int LEDGO();
int LEDNG();
int LEDOFF();
int BEEP(int freq, int time);



int INIT2(unsigned long modaddr);
int EXIT2(unsigned long modaddr);
int VALIDDEV2(unsigned long modaddr);
int PON2(unsigned long modaddr);
int POFF2(unsigned long modaddr);
int PWRCTL_AUTO2(unsigned long modaddr);
int PWRCTL_MANUAL2(unsigned long modaddr);
int GETPWRSTS2(unsigned long modaddr);
int GET3V3V2(unsigned long modaddr, double* volt);
int GET3V3I2(unsigned long modaddr, double* amp);
void GETFIRMVER(int* major, int* minor);
void GETLIBVER(int* major, int* minor);


// New add function
int RESCAN();
int RESCAN2(unsigned long modaddr);
int GET1V5I(double* amp);
int GET1V5V(double* volt);
int GET12VI(double* amp);
int GET12VV(double* volt);
int GET12VI2(unsigned long modaddr, double* amp);
int GET12VV2(unsigned long modaddr, double* volt);
int CHKSHORT(unsigned long modaddr);
int LEDGO2(unsigned long modaddr);
int LEDNG2(unsigned long modaddr);
int LEDOFF2(unsigned long modaddr);
int BEEP2(unsigned long modaddr, int freq, int time);

// Need modify
int SETPONRST(int setting);
int SELDEV(unsigned long Busno, unsigned long Devno);
int WAITCARDREMOVE();
int WAITCARDPLUG();
unsigned long GETPCIDEVVID();
unsigned long GETPCIDEVDID();

int SET1V5ICAL(unsigned long modaddr);
int SET3V3ICAL(unsigned long modaddr);
int SET12ICAL(unsigned long modaddr);

int SETUSECAL(int i);
int GETUSECAL();


#endif
